
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [35, 25, 15, 10, 8, 7]
labels = [
    "Technology\n35%",
    "Healthcare\n25%",
    "Finance\n15%",
    "Education\n10%",
    "Manufacturing\n8%",
    "Services\n7%",
]

# Labels and Titles
title = "Sectoral Employment Distribution in Urban Area"
subtitle = "By Percentage of Workforce in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700", "#FF69B4"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 16},
    ec="white",
)

# Add a title and subtitle
plt.title(title, fontsize=24)
plt.suptitle(subtitle, fontsize=16, y=0.93)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_27.pdf", bbox_inches="tight")

