
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [30.0, 25.0, 20.0, 10.0, 5.0, 5.0, 5.0]
labels = [
    "Sunny\n30.0%",
    "Partly Cloudy\n25.0%",
    "Cloudy\n20.0%",
    "Rainy\n10.0%",
    "Snowy\n5.0%",
    "Stormy\n5.0%",
    "Foggy\n5.0%",
]

# Titles and Text Labels
title = "Distribution of Weather Conditions"
suptitle = "Weather Condition Analysis"
savefile = "tree_28_1.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors: Warm and inviting palette for weather theme
colors = ["#FA8072", "#87CEEB", "#FFA07A", "#20B2AA", "#9370DB", "#FFD700", "#FF69B4"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add Titles
plt.title(title, fontsize=20, fontweight="bold")
plt.suptitle(suptitle, fontsize=24, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_28.pdf", bbox_inches="tight")

