
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [40, 30, 15, 10, 5]  # New percentages for renewable energy sources
labels = ["Solar Energy (40%)", "Wind Energy (30%)", "Hydro Energy (15%)", "Biomass Energy (10%)", "Geothermal Energy (5%)"]
title = 'Distribution of Renewable Energy Sources'
xlabel = 'Energy Type'
ylabel = 'Percentage'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

colors = ["#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    ec="white"
)

# Add a title
plt.title(title, fontsize=18, fontweight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_31.pdf", bbox_inches="tight")
