
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for household budget distribution in different categories
sizes = [30, 20, 20, 10, 10, 10]
labels = [
    "Housing 30%",
    "Food 20%",
    "Transportation 20%",
    "Healthcare 10%",
    "Entertainment 10%",
    "Savings 10%",
]

# Title and figure size
title = "Household Budget Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size

# Color palette
colors = ["#377eb8", "#4daf4a", "#e41a1c", "#ff7f00", "#984ea3", "#ffff33"]

# Chart text properties
text_properties = {"fontsize": 12, "fontweight": "bold", "color": "white"}

fig = plt.figure(figsize=(8, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs=text_properties,
    ec="white",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=16, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_32.pdf", bbox_inches="tight")
