
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [25, 15, 20, 10, 20, 10]  # Example sizes representing investment distribution
labels = [
    "Tech\n25%",
    "Healthcare\n15%",
    "Finance\n20%",
    "Real Estate\n10%",
    "Energy\n20%",
    "Consumer Goods\n10%",
]
title = "Diversified Investment Portfolio Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 8))

# Define custom colors
colors = ["#FF6347", "#FFD700", "#8A2BE2", "#3CB371", "#1E90FF", "#FF69B4"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white"},
    pad=True,
    ec="black",
)

# Set title
plt.title(title, fontsize=20, fontweight="bold")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_33.pdf", bbox_inches="tight")

# Show the plot
