
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [35, 25, 15, 12, 8, 5]
labels = [
    "Wheat\n35%",
    "Rice\n25%",
    "Corn\n15%",
    "Soybean\n12%",
    "Barley\n8%",
    "Oats\n5%",
]
# Text label parameters
title = "Distribution of Crop Production"
suptitle = "Agricultural Crop Production 2023"
xlabel = "Crops"
ylabel = "Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
# Colors: Pastel hues
colors = ["#FFB6C1", "#ADD8E6", "#98FB98", "#FFDAB9", "#E6E6FA", "#FFFACD"]

fig = plt.figure(figsize=(8, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title and suptitle
plt.suptitle(suptitle, fontsize=20, fontweight="bold")
plt.title(title, fontsize=16, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_34.pdf", bbox_inches="tight")
