
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [30, 20, 20, 15, 10, 5]
labels = [
    "Sunny\n30%",
    "Rainy\n20%",
    "Cloudy\n20%",
    "Snowy\n15%",
    "Windy\n10%",
    "Stormy\n5%",
]
# Title for the chart
title = "Distribution of Weather Conditions Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 8))

# Colors representing different weather conditions
colors = ["#1f77b4", "#d62728", "#2ca02c", "#ff7f0e", "#9467bd", "#8c564b"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "white"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Set title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_35.pdf", bbox_inches="tight")
