
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [30.0, 27.0, 23.0, 15.0, 5.0]
labels = [
    "Forests\n30.0%",
    "Grasslands\n27.0%",
    "Agriculture\n23.0%",
    "Urban areas\n15.0%",
    "Wetlands\n5.0%",
]

# Plot text configurations
title = "Global Land Usage Distribution (in %)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

text_kwargs = {"fontsize": 18}
title_kwargs = {"fontsize": 24, "fontweight": "bold"}

new_colors = [
    "#1f77b4",  # Blue for Forests
    "#ff7f0e",  # Orange for Grasslands
    "#2ca02c",  # Green for Agriculture
    "#d62728",  # Red for Urban areas
    "#9467bd",  # Purple for Wetlands
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=new_colors, alpha=0.8, text_kwargs=text_kwargs
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, **title_kwargs)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_37.pdf", bbox_inches="tight")
