
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [30.0, 25.0, 20.0, 15.0, 5.0, 3.0, 2.0]
labels = [
    "Banking\n30.0%",
    "Insurance\n25.0%",
    "Investment\n20.0%",
    "Real Estate\n15.0%",
    "Fintech\n5.0%",
    "Hedge Funds\n3.0%",
    "Other\n2.0%",
]

# Text labels
title_text = "Market Share by Financial Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Colors reflecting financial themes
colors = [
    "#2c7bb6",
    "#abd9e9",
    "#ffffbf",
    "#fee08b",
    "#fdae61",
    "#d73027",
    "#1a9850",
]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 18, "weight": "bold"},
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title_text, fontsize=22, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_38.pdf", bbox_inches="tight")
