
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New data for tourism market share
sizes = [0.25, 0.20, 0.18, 0.15, 0.12, 0.10]
labels = [
    "France\n25%",
    "Spain\n20%",
    "United States\n18%",
    "China\n15%",
    "Italy\n12%",
    "Others\n10%",
]
title = "Global Tourism Market Share by Country"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Color scheme suitable for technology domain
colors = ["#1f78b4", "#33a02c", "#e31a1c", "#ff7f00", "#6a3d9a", "#b15928"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24, color="#333333")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_42.pdf", bbox_inches="tight")
