
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New data for educational attainment levels
sizes = [0.30, 0.25, 0.20, 0.15, 0.08, 0.02]
labels = [
    "High School\n30%",
    "Bachelor's Degree\n25%",
    "Master's Degree\n20%",
    "Associate's Degree\n15%",
    "Doctorate\n8%",
    "Others\n2%",
]
title = "Educational Attainment Levels in Society"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Color palette reflecting a contemplative theme
colors = ["#3c5488", "#4a87d4", "#76b7c3", "#aab7a9", "#efd399", "#f28e2b"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_43.pdf", bbox_inches="tight")
