

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# New data for population distribution by age groups (in percentages)
sizes = [0.25, 0.20, 0.18, 0.15, 0.12, 0.10]
labels = [
    "0-14 years\n25%",
    "15-24 years\n20%",
    "25-34 years\n18%",
    "35-44 years\n15%",
    "45-54 years\n12%",
    "55+ years\n10%",
]
title = "Population Distribution by Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_44.pdf", bbox_inches="tight")

