
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [90, 80, 75, 60, 50, 45]
labels = [
    "Great Wall of China\n90M",
    "Machu Picchu\n80M",
    "Eiffel Tower\n75M",
    "Statue of Liberty\n60M",
    "Taj Mahal\n50M",
    "Sydney Opera House\n45M",
]

# Text labels and title
title = "Top Tourist Attractions by Visitor Numbers"
suptitle = "Representation by Millions of Visitors Annually"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=0.3,
)

# Add title and supertitle
plt.title(title, fontsize=24,y=1.1)
plt.suptitle(suptitle, fontsize=18, y=0.85)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save plot
plt.savefig("tree_45.pdf", bbox_inches="tight")
