
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy
import numpy as np

# Data
sizes = [0.40, 0.25, 0.15, 0.10, 0.10]
labels = [
    "Fiction\n40%",
    "Non-Fiction\n25%",
    "Science Fiction\n15%",
    "Fantasy\n10%",
    "Other\n10%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot text properties
text_properties = {"fontsize": 14, "color": "white"}

colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974"]

# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs=text_properties,
    pad=0.3,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save plot
plt.savefig("tree_46.pdf", bbox_inches="tight")
