

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [0.30, 0.20, 0.18, 0.12, 0.10, 0.10]
labels = [
    "Asia\n30%",
    "Africa\n20%",
    "Europe\n18%",
    "North America\n12%",
    "South America\n10%",
    "Australia\n10%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6347", "#4682B4", "#32CD32", "#FFD700", "#6A5ACD", "#FF1493"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_48.pdf", bbox_inches="tight")

