
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.60, 0.16, 0.12, 0.07, 0.03, 0.02]
labels = [
    "Asia\n60%",
    "Africa\n16%",
    "Europe\n12%",
    "North America\n7%",
    "South America\n3%",
    "Oceania\n2%",
]

# Text label parameters
title = "Population Distribution by Continent (2023)"
legend_labels = ["Asia", "Africa", "Europe", "North America", "South America", "Oceania"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700", "#FFB6C1"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_49.pdf", bbox_inches="tight")
