

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [0.33, 0.27, 0.15, 0.12, 0.08, 0.05]
labels = [
    "Cardiovascular Diseases\n33%",
    "Respiratory Diseases\n27%",
    "Diabetes\n15%",
    "Cancer\n12%",
    "Mental Health Issues\n8%",
    "Other\n5%",
]
title = "Distribution of Health Conditions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#6b705c", "#cb997e", "#ddbea9", "#ffe8d6", "#b7b7a4", "#a5a58d"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 16, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# Title
plt.title(title, fontsize=24, weight='bold', color="#3d405b")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_50.pdf", bbox_inches="tight")

