
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [0.30, 0.25, 0.20, 0.10, 0.10, 0.05]
labels = [
    "Christianity\n30%",
    "Islam\n25%",
    "Hinduism\n20%",
    "Buddhism\n10%",
    "Judaism\n10%",
    "Other Religions\n5%",
]

# Text labels
title = "Distribution of Religions in a Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# New color scheme
colors = ["#4a90e2", "#50e3c2", "#bd10e0", "#f5a623", "#f8e71c", "#d0011b"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_51.pdf", bbox_inches="tight")
