

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.30, 0.25, 0.20, 0.15, 0.07, 0.03]
labels = [
    "Cognitive Behavioral Therapy\n30%",
    "Psychoanalytic Therapy\n25%",
    "Humanistic Therapy\n20%",
    "Integrative or Holistic Therapy\n15%",
    "Behavioral Therapy\n7%",
    "Others\n3%",
]

# Text properties
title = "Market Share of Therapy Approaches in Psychology (2023)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#74c476", "#31a354", "#006d2c", "#fd8d3c", "#e6550d", "#a63603"]

# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Title setting
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_52.pdf", bbox_inches="tight")

