
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [0.30, 0.25, 0.20, 0.10, 0.08, 0.07]
labels = [
    "Brand A\n30%",
    "Brand B\n25%",
    "Brand C\n20%",
    "Brand D\n10%",
    "Brand E\n8%",
    "Other\n7%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

colors = ["#A6CEE3", "#1F78B4", "#B2DF8A", "#33A02C", "#FB9A99", "#E31A1C"]
text_kwargs = {"fontsize": 18, "color": "white"}

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs=text_kwargs,
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_53.pdf", bbox_inches="tight")
