
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30.0, 25.0, 20.0, 10.0, 8.0, 5.0, 2.0]
labels = [
    "Inpatient Services\n30.0%",
    "Outpatient Services\n25.0%",
    "Pharmaceuticals\n20.0%",
    "Medical Devices\n10.0%",
    "Preventive Care\n8.0%",
    "Administrative Costs\n5.0%",
    "Others\n2.0%",
]

title = 'Healthcare Expense Distribution'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#FFA07A", "#20B2AA", "#FFB347", "#FF9671"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22, weight="bold")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_55.pdf", bbox_inches="tight")
