
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# import numpy as np
# Data
sizes = [89, 85, 75, 72, 70, 68, 65]  # Total goals in a season for various top football clubs
total_size = sum(sizes)
percentages = [size / total_size * 100 for size in sizes]
labels = [
    f"Barcelona\n{percentages[0]:.1f}%",
    f"Real Madrid\n{percentages[1]:.1f}%",
    f"Liverpool\n{percentages[2]:.1f}%",
    f"Manchester City\n{percentages[3]:.1f}%",
    f"Bayern Munich\n{percentages[4]:.1f}%",
    f"PSG\n{percentages[5]:.1f}%",
    f"Juventus\n{percentages[6]:.1f}%",
]

title = 'Top Football Clubs by Total Goals in a Season'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462", "#b3de69"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_56.pdf", bbox_inches="tight")
