
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [12.0, 15.3, 18.2, 21.7, 14.5, 18.3]
labels = [
    "0-14 years\n12.0%",
    "15-24 years\n15.3%",
    "25-54 years\n18.2%",
    "55-64 years\n21.7%",
    "65-74 years\n14.5%",
    "75+ years\n18.3%",
]
title = 'Population Distribution by Age Groups'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1", "#955251"]

# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=22, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_59.pdf", bbox_inches="tight")
