

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [40, 25, 20, 5, 5, 5]
labels = [
    "Forest\n40%",
    "Grassland\n25%",
    "Wetlands\n20%",
    "Urban\n5%",
    "Desert\n5%",
    "Agriculture\n5%",
]
title = 'Distribution of Ecosystem Land Cover'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#a2cffe", "#b39eb5", "#ffdfba", "#d7f1d0", "#f7cac9", "#c6c08e"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_60.pdf", bbox_inches="tight")
