
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [25, 20, 18, 15, 12, 10]
labels = [
    "18-24\n25%",
    "25-34\n20%",
    "35-44\n18%",
    "45-54\n15%",
    "55-64\n12%",
    "65+\n10%",
]
title = 'Distribution of Internet Users by Age Group'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#FFD700", "#87CEEB", "#00BFFF", "#A9A9A9", "#708090", "#FF8C00"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_61.pdf", bbox_inches="tight")
