

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [35, 30, 20, 10, 3, 2]
labels = [
    "Facebook\n35%",
    "Instagram\n30%",
    "Twitter\n20%",
    "LinkedIn\n10%",
    "Snapchat\n3%",
    "Pinterest\n2%",
]
title = 'Social Media Usage Distribution Among Users'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#2E8B57", "#556B2F", "#66CDAA", "#8FBC8F", "#3CB371", "#20B2AA"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_62.pdf", bbox_inches="tight")

