
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data - Investment Categories
sizes = [40, 20, 15, 10, 5, 10]
labels = [
    "Stocks - 40%", 
    "Bonds - 20%", 
    "Real estate - 15%", 
    "Mutual funds - 10%", 
    "Gold - 5%", 
    "Cryptocurrencies - 10%"
]
title = "Investment Portfolio Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#3498DB", "#E74C3C", "#2ECC71", "#8E44AD", "#F1C40F", "#95A5A6"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    edgecolor="white",  # Improved border visibility
    linewidth=2  # Added edge line width for better visuals
)

# Set plot title
plt.title(title, fontsize=18, color='black', weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_63.pdf", bbox_inches="tight")
