
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [25, 20, 18, 15, 12, 10]
labels = [
    "Education\n25%",
    "Healthcare\n20%",
    "Transportation\n18%",
    "Recreation\n15%",
    "Housing\n12%",
    "Food\n10%"
]
title = "Societal Expenditures by Category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
# Create a figure with the specified size
fig = plt.figure(figsize=(6, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "white"},
    ec="white",
)

# Set the title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_71.pdf", bbox_inches="tight")
