

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [40, 30, 15, 10, 5]
labels = [
    "Bachelor's\n40%",
    "Master's\n30%",
    "Doctorate\n15%",
    "Associate's\n10%",
    "Certificates\n5%"
]
title = "Degree Award Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#E50914", "#232F3E", "#113CCF", "#1CE783", "#7A1FA2"]

# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white"},
    pad=True,
    ec="black",
)

# Set title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_72.pdf", bbox_inches="tight")
