
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [40, 25, 15, 10, 10]
labels = ["Car\n40%", "Bicycle\n25%", "Bus\n15%", "Train\n10%", "Walking\n10%"]
title = "Modes of Transportation Usage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Text label parameters
text_kwargs = {"fontsize": 14, "color": "black", "weight": "bold"}

colors = ["#87CEEB", "#DDA0DD", "#FFB6C1", "#8A2BE2", "#98FB98"]

# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs=text_kwargs,
    pad=True,
    ec="white",
)

# Set title
plt.title(title, fontsize=20, weight="bold", pad=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_74.pdf", bbox_inches="tight")
