
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [300, 200, 150, 120, 100, 80, 60, 40]  # Contribution of each pollution source in mega-tons
labels = [
    "Transportation\n300 MT",
    "Industrial\n200 MT",
    "Agriculture\n150 MT",
    "Residential\n120 MT",
    "Energy Production\n100 MT",
    "Waste Disposal\n80 MT",
    "Natural Sources\n60 MT",
    "Other\n40 MT",
]
title = "Distribution of Pollution Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 12, "color": "black"},
    pad=True,
    ec="white",
)

# Add a title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_75.pdf", bbox_inches="tight")
