
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40, 27, 22, 6, 5]
labels = [
    "Oil\n40%",
    "Coal\n27%",
    "Natural Gas\n22%",
    "Hydro\n6%",
    "Renewables\n5%",
]
title = "Global Energy Consumption by Source in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

colors = [
    "#0000FF",
    "#FF0000",
    "#008000",
    "#FFD700",
    "#808080",
]  # Blue, Red, Green, Gold, Grey

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white", "weight": "bold"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=16, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_78.pdf", bbox_inches="tight")
