
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for temperature distribution
temperature_distribution = {
    "Winter": {
        "Day": np.random.normal(5, 3, 100),
        "Night": np.random.normal(-2, 4, 100),
    },
    "Spring": {
        "Day": np.random.normal(15, 5, 100),
        "Night": np.random.normal(8, 3, 100),
    },
    "Summer": {
        "Day": np.random.normal(30, 6, 100),
        "Night": np.random.normal(20, 4, 100),
    },
    "Autumn": {
        "Day": np.random.normal(20, 5, 100),
        "Night": np.random.normal(10, 3, 100),
    },
}

title = "Temperature Distribution Across Seasons"
xlabel = "Time of Day"
ylabel = "Temperature (°C)"
xticklabels = ["Day", "Night"]
xticks = [1, 2]

# Prepare data for violin plot
data_to_plot = []
for season_name, times in temperature_distribution.items():
    data_to_plot.extend([temps for time, temps in times.items()])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ['#1f77b4', '#ff7f0e']  # Blue for Day, Orange for Night

# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (season_name, ax) in enumerate(zip(temperature_distribution, axs)):
    time_temps = temperature_distribution[season_name]
    vp = ax.violinplot([time_temps["Day"], time_temps["Night"]], showmeans=True, showmedians=True)

    # Set custom color for each time of day
    for pc, color in zip(vp['bodies'], colors):
        pc.set_facecolor(color)
        pc.set_edgecolor('black')
        pc.set_alpha(0.6)

    # Set title and labels
    ax.set_title(f"{title}: {season_name}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_47.pdf", bbox_inches="tight")
