
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New data representing monthly stock market returns for different stocks
data_StockA = np.random.normal(2, 5, 200)  # Monthly returns (%) for Stock A
data_StockB = np.random.normal(1, 4, 200)  # Monthly returns (%) for Stock B
data_StockC = np.random.normal(0, 3, 200)  # Monthly returns (%) for Stock C

xticklabels = ["Stock A", "Stock B", "Stock C"]
ylabel = "Monthly Returns (%)"
title = "Monthly Stock Market Returns for Different Stocks"
ylim = [-20, 20]
xticks = [1, 2, 3]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with enhanced styling
violin_parts1 = ax.violinplot(data_StockA, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_StockB, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_StockC, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#66c2a5")  # Green shade
violin_parts1["bodies"][0].set_alpha(0.7)

violin_parts2["bodies"][0].set_facecolor("#8da0cb")  # Blue shade
violin_parts2["bodies"][0].set_alpha(0.7)

violin_parts3["bodies"][0].set_facecolor("#fc8d62")  # Yellow-orange shade
violin_parts3["bodies"][0].set_alpha(0.7)

# Customize mean line colors and style
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    # Stock A
    vp = violin_parts1[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))  # Dotted line
    vp.set_linewidth(1.5)

    # Stock B
    vp = violin_parts2[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))
    vp.set_linewidth(1.5)

    # Stock C
    vp = violin_parts3[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_69.pdf", bbox_inches="tight")
