
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# New data representing response times for different communication channels (in minutes)
data_Email = np.random.normal(7, 0.5, 200)
data_SocialMedia = np.random.normal(5, 1.5, 200)
data_PhoneSupport = np.random.normal(3, 1, 200)

xticklabels = ["Email", "Social Media", "Phone Support"]
ylabel = "Response Time (minutes)"
title = "Response Time Across Communication Channels"
ylim = [0, 15]
xticks = [1, 2, 3]
legends = ["Email", "Social Media", "Phone Support"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with transparency
violin_parts1 = ax.violinplot(data_Email, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_SocialMedia, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_PhoneSupport, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#8c564b")
violin_parts1["bodies"][0].set_alpha(0.6)

violin_parts2["bodies"][0].set_facecolor("#2ca02c")
violin_parts2["bodies"][0].set_alpha(0.6)

violin_parts3["bodies"][0].set_facecolor("#ff7f0e")
violin_parts3["bodies"][0].set_alpha(0.6)

# Customize mean line colors
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    vp = violin_parts1[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

    vp = violin_parts2[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

    vp = violin_parts3[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# Add legend for clarity
plt.legend(legends, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_70.pdf", bbox_inches="tight")
