
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New data representing public engagement scores for different community events
data_LocalFestivals = np.random.normal(0.65, 0.10, 200)
data_CommunityMeetings = np.random.normal(0.55, 0.03, 200)
data_VolunteerEvents = np.random.normal(0.70, 0.08, 200)

xticklabels = ["Local Festivals", "Community Meetings", "Volunteer Events"]
ylabel = "Public Engagement Scores"
title = "Public Engagement Across Different Community Events"
ylim = [0.2, 1.0]
xticks = [1, 2, 3]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with transparency
violin_parts1 = ax.violinplot(data_LocalFestivals, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_CommunityMeetings, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_VolunteerEvents, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#1f77b4")  # Blue
violin_parts1["bodies"][0].set_alpha(0.7)

violin_parts2["bodies"][0].set_facecolor("#2ca02c")  # Green
violin_parts2["bodies"][0].set_alpha(0.7)

violin_parts3["bodies"][0].set_facecolor("#9467bd")  # Purple
violin_parts3["bodies"][0].set_alpha(0.7)

# Customize mean line colors
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    vp = violin_parts1[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

    vp = violin_parts2[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

    vp = violin_parts3[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_71.pdf", bbox_inches="tight")
