# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate data for different metrics of computer performance (CPU, GPU, RAM)
np.random.seed(42)

# CPU performance data
cpu = np.random.normal(loc=3.5, scale=0.5, size=50)  # mean performance around 3.5 GHz

# GPU performance data
gpu = np.random.uniform(low=1.5, high=3.0, size=50)  # randomly between 1.5 and 3.0 GHz

# RAM performance data
ram = np.random.normal(loc=16, scale=4, size=50)  # mean capacity around 16 GB

# Second set of data for variations in different conditions
cpu2 = np.random.normal(loc=3.7, scale=0.4, size=50)
gpu2 = np.random.uniform(low=1.4, high=2.8, size=50)
ram2 = np.random.normal(loc=15, scale=5, size=50)

labels = ["Performance Set 1", "Performance Set 2"]
xlabel = "CPU Performance (GHz)"
ylabel = "GPU Performance (GHz)"
zlabel = "RAM Performance (GB)"
title = "Computer Performance Variations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([2.5, 4.5])
ax.set_ylim3d([1.0, 3.5])
ax.set_zlim3d([5, 25])

# Set the viewing angle
ax.view_init(elev=25, azim=60)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(cpu, gpu, ram, color="green", marker='o', label=labels[0])

# Scatter plot for the second set of data
ax.scatter3D(cpu2, gpu2, ram2, color="orange", marker='^', label=labels[1])

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15)

# Legend for the plot
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_16.pdf", bbox_inches="tight")

