# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set a random seed for reproducibility
np.random.seed(32)
# Data for plotting (let's simulate some different sets of data, e.g., population density)
X = np.linspace(-10, 10, 100)
Y = np.linspace(-10, 10, 100)
X, Y = np.meshgrid(X, Y)
Z1 = np.exp(-(X**2 + Y**2) / 25)
Z2 = np.exp(-((X+3)**2 + (Y+3)**2) / 25)

# Titles and labels
title1 = "Population Density Distribution 1"
title2 = "Population Density Distribution 2"
xlabel = "Longitude"
ylabel = "Latitude"
zlabel = "Population Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig, axs = plt.subplots(1, 2, figsize=(14, 6), subplot_kw={"projection": "3d"})

# First subplot
axs[0].plot_surface(X, Y, Z1, cmap="coolwarm", edgecolor="none", alpha=0.80)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].set_zlabel(zlabel)

# Second subplot
axs[1].plot_surface(X, Y, Z2, cmap="coolwarm", edgecolor="none", alpha=0.80)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].set_zlabel(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_17.pdf", bbox_inches="tight")