# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Set a random seed for reproducibility
np.random.seed(0)
# Define the data for the technological metrics surface plots
x = np.linspace(-100, 100, 200)  # Increased range for diversity
y = np.linspace(-100, 100, 200)  # Increased range for diversity
x, y = np.meshgrid(x, y)
z1 = 0.002 * (x**2 + y**2)  # A concave shape representing Innovation Index
z2 = 0.005 * (x * y)  # A saddle shape representing Research Index
z3 = np.cos(0.05 * np.sqrt(x**2 + y**2))  # A wave pattern for Development Index
z4 = np.exp(-((x / 30)**2 + (y / 30)**2))  # Gaussian for Technological Index

# Define titles and labels
title1 = "Innovation Index"
title2 = "Research Index"
title3 = "Development Index"
title4 = "Technological Index"
xlabel = "X Axis"
ylabel = "Y Axis"
zlabel1 = "Innovation Value"
zlabel2 = "Research Value"
zlabel3 = "Development Value"
zlabel4 = "Technological Value"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fontsize = 12
title_pad = 10
# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(14, 10))

# Plot the first subplot
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")  # Set background to white
surf1 = ax1.plot_surface(x, y, z1, cmap="plasma", edgecolor='none')
ax1.set_title(title1, fontsize=fontsize, pad=title_pad)
ax1.set_xlabel(xlabel, fontsize=fontsize)  # Increased font size
ax1.set_ylabel(ylabel, fontsize=fontsize)  # Increased font size
ax1.set_zlabel(zlabel1, fontsize=fontsize)  # Increased font size

# Plot the second subplot
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="inferno", edgecolor='none')
ax2.set_title(title2, fontsize=fontsize, pad=title_pad)
ax2.set_xlabel(xlabel, fontsize=fontsize)
ax2.set_ylabel(ylabel, fontsize=fontsize)
ax2.set_zlabel(zlabel2, fontsize=fontsize)

# Plot the third subplot
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="magma", edgecolor='none')
ax3.set_title(title3, fontsize=fontsize, pad=title_pad)
ax3.set_xlabel(xlabel, fontsize=fontsize)
ax3.set_ylabel(ylabel, fontsize=fontsize)
ax3.set_zlabel(zlabel3, fontsize=fontsize)

# Plot the fourth subplot
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="cividis", edgecolor='none')
ax4.set_title(title4, fontsize=fontsize, pad=title_pad)
ax4.set_xlabel(xlabel, fontsize=fontsize)
ax4.set_ylabel(ylabel, fontsize=fontsize)
ax4.set_zlabel(zlabel4, fontsize=fontsize)

# Make sure all subplots have a consistent view initialization
for ax in [ax1, ax2, ax3, ax4]:
    ax.view_init(30, 45)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Save the plot to a file
plt.savefig("3d_18.pdf", bbox_inches="tight")