import numpy as np; np.random.seed(0)

np.random.seed(0)

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# data
ap = np.array(
    [
        [
            0.06,
            0.01,
            -0.0,
            0.01,
            0.11,
            0.04,
            0.08,
            0.05,
            0.04,
            0.01,
            0.05,
            0.16,
            0.2,
            0.16,
            -0.03,
            -0.17,
            -0.07,
        ],
        [
            0.07,
            0.19,
            0.14,
            0.21,
            -0.04,
            -0.04,
            -0.02,
            0.11,
            0.1,
            -0.02,
            0.05,
            -0.04,
            -0.14,
            -0.12,
            0.12,
            0.22,
            0.14,
        ],
        [
            0.37,
            0.43,
            -0.1,
            -0.53,
            0.42,
            -0.1,
            -0.53,
            0.6,
            0.84,
            0.89,
            1.01,
            0.81,
            0.62,
            0.5,
            0.82,
            0.66,
            0.5,
        ],
    ]
)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xp = ap[0]
yp = ap[1]
zp = ap[2]
fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.view_init(elev=15.0, azim=70)
ax.dist = 7.5

# 3D scatter
ax.scatter3D(xp, yp, zp, color="darkorange", label="Targets")

# draw the body
# left leg
ax.plot(xp[0:4], yp[0:4], zp[0:4], ls="-", color="orange")
# right leg
ax.plot(
    np.hstack((xp[0], xp[4:7])),
    np.hstack((yp[0], yp[4:7])),
    np.hstack((zp[0], zp[4:7])),
    ls="-",
    color="orange",
)
# spine
ax.plot(
    np.hstack((xp[0], xp[7:11])),
    np.hstack((yp[0], yp[7:11])),
    np.hstack((zp[0], zp[7:11])),
    ls="-",
    color="orange",
)
# right arm
ax.plot(
    np.hstack((xp[8], xp[11:14])),
    np.hstack((yp[8], yp[11:14])),
    np.hstack((zp[8], zp[11:14])),
    ls="-",
    color="orange",
)
# left arm
ax.plot(
    np.hstack((xp[8], xp[14:])),
    np.hstack((yp[8], yp[14:])),
    np.hstack((zp[8], zp[14:])),
    ls="-",
    color="orange",
)

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_5.pdf", bbox_inches="tight")
