import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample (x,y) for the scatter plot
data = {
    "morning": [[np.random.rand() * 10 + 20, np.random.rand() * 10 + 40] for _ in range(10)],
    "noon": [[np.random.rand() * 10 + 30, np.random.rand() * 10 + 30] for _ in range(2)],
    "evening": [[np.random.rand() * 10 + 40, np.random.rand() * 10 + 20] for _ in range(10)],
    "night": [[np.random.rand() * 10 + 50, np.random.rand() * 10 + 10] for _ in range(10)],
}

line_x = np.array([20, 60])
line_y = np.array([10, 50])

colors = [
    "#c76526",
    "#469c76",
    "#d39334",
    "#3171ad",
]  # Use HEX color codes for muted colors
labels = ["morning", "noon", "evening", "night"]
correlation = 0.65
xlabel = "Time of Day"
ylabel = "Traffic Speed (km/h)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create scatter plot
plt.figure(figsize=(7, 5))  # Adjust figure size to match original image dimensions

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key)

# Add regression line
plt.plot(line_x, line_y, color="black")

# Add shaded area for standard deviation
std_dev = 0.5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="black", alpha=0.1)

# Add legend inside the plot area
plt.legend(loc="center left")

# Add correlation text with a box inside the plot area
plt.text(line_x.mean(), line_y.mean(), f"Correlation: {correlation:.2f}", fontsize=9)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Set grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('CB_11.pdf', bbox_inches='tight')
