import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for demonstration purposes
solar_energy_data = np.random.beta(a=3, b=9, size=1000) * 100  # Solar energy output in kWh
wind_energy_data = np.random.beta(a=5, b=5, size=1000) * 100   # Wind energy output in kWh

# Compute KDE for both datasets
kde_solar = gaussian_kde(solar_energy_data)
kde_wind = gaussian_kde(wind_energy_data)

# Create an array of values for plotting KDE
x_eval = np.linspace(
    min(np.concatenate([solar_energy_data, wind_energy_data])),
    max(np.concatenate([solar_energy_data, wind_energy_data])),
    1000,
)
labels = ["Solar Energy", "Wind Energy", "Solar KDE", "Wind KDE"]
p_text = "T-test p-value = 0.0000"
x_label = "Energy Output (kWh)"
y_label = "Density"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Plot histograms
plt.hist(
    wind_energy_data, density=True, bins=30, color="salmon", alpha=0.8, label=labels[0]
)
plt.hist(solar_energy_data, density=True, bins=30, color="#bad7b5", alpha=0.8, label=labels[1])

# Plot KDEs
plt.plot(
    x_eval,
    kde_wind(x_eval),
    linestyle="dashed",
    color="darkred",
    label=labels[2],
)
plt.plot(
    x_eval,
    kde_solar(x_eval),
    linestyle="dashed",
    color="darkgreen",
    label=labels[3],
)

# Add legend
plt.legend()

# Add T-test p-value text
plt.text(25, 0.035, p_text, fontsize=10)

# Set labels and title
plt.xlabel(x_label)
plt.ylabel(y_label)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('CB_12.pdf', bbox_inches='tight')