import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data
vehicles = ["Bike", "Car", "Bus", "Train", "Airplane", "Ship"]
usage = [80, 60, 80, 120, 420, 260]
efficiency = [120, 160, 40, 180, 100, 40]
emissions = [80, 120, 200, 260, 200, 220]
usage_trend = [80, 60, 80, 120, 420, 260]
labels = ["Usage", "Efficiency", "Emissions", "Usage Trend"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(8, 5)
)  # Adjusting figure size to match the original image's dimensions

bar_width = 0.25
index = np.arange(len(vehicles))

bar1 = ax.bar(
    index, usage, bar_width, label=labels[0], color="#db7a6e", edgecolor="grey"
)
bar2 = ax.bar(
    index + bar_width,
    efficiency,
    bar_width,
    label=labels[1],
    color="#e5a893",
    edgecolor="grey",
)
bar3 = ax.bar(
    index + 2 * bar_width,
    emissions,
    bar_width,
    label=labels[2],
    color="#f9ebe7",
    edgecolor="grey",
)

# Trend line for 'Usage Trend'
ax.plot(
    index,
    usage_trend,
    color="#cb56ae",
    marker="o",
    linestyle="dashed",
    label=labels[3],
)

# Adding percentages on top of the bars
for i, rect in enumerate(bar1 + bar2 + bar3):
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        f"{height}%",
        ha="center",
        va="bottom",
    )

# Labels, title and custom x-axis tick labels
ax.set_xlabel("Vehicle")
ax.set_ylabel("Metric Value")
ax.set_yticks(np.arange(0, 601, 100))
ax.set_title("Transportation Metrics by Vehicle Type")
ax.set_xticks(index + bar_width)
ax.set_xticklabels(vehicles, rotation=30)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('CB_2.pdf', bbox_inches='tight')
