import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the line plot
traffic_speed_am = np.random.normal(30, 5, 100)
traffic_speed_pm = np.random.normal(25, 7, 100)
traffic_speed_night = np.random.normal(35, 6, 100)

kde_am = gaussian_kde(traffic_speed_am)
kde_pm = gaussian_kde(traffic_speed_pm)
kde_night = gaussian_kde(traffic_speed_night)

x_range = np.linspace(0, 60, 50)
labels = ["Morning", "Evening", "Night"]
title = "Time of Day"
xlabel = "Speed (mph)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific size to match the original image's dimensions
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(8, 4), gridspec_kw={"height_ratios": [3, 2]}
)

# Line plot
ax1.fill_between(x_range, kde_am(x_range), color="skyblue", alpha=0.4)
ax1.fill_between(x_range, kde_pm(x_range), color="sandybrown", alpha=0.5)
ax1.fill_between(x_range, kde_night(x_range), color="olivedrab", alpha=0.3)
ax1.plot(x_range, kde_am(x_range), label=labels[0], color="blue")
ax1.plot(x_range, kde_pm(x_range), label=labels[1], color="orange")
ax1.plot(x_range, kde_night(x_range), label=labels[2], color="green")
ax1.legend(title=title, loc="upper left")
ax1.set_xticks([])
ax1.set_yticks([])

# Box plot
box = ax2.boxplot(
    [traffic_speed_am, traffic_speed_pm, traffic_speed_night], vert=False, patch_artist=True, medianprops={"color": "black"}
)
colors = ["skyblue", "sandybrown", "olivedrab"]
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_xlabel(xlabel)
ax2.set_yticks([])
ax2.set_xlim(0, 60)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('CB_21.pdf', bbox_inches='tight')
