# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
sources = [
    "Solar",
    "Wind",
    "Hydropower",
    "Nuclear",
    "Coal",
    "Natural Gas",
]
cost_per_kwh = [0.06, 0.04, 0.05, 0.09, 0.12, 0.08]
emissions_per_kwh = [0.02, 0.02, 0.01, 0.0, 0.3, 0.2]
efficiency = [0.2, 0.3, 0.4, 0.35, 0.25, 0.3]
setup_time_years = [1, 2, 3, 5, 2, 3]
output_mwh = [250, 300, 400, 350, 200, 300]
labels = ["Cost per kWh ($)", "Emissions per kWh (kg CO2)", "Efficiency (%)", "Setup Time (years)"]
x_name = "Energy Sources"
bar_name = "Normalized Metrics (lower is better)"
line_name = "Output (MWh)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image's dimensions
fig, ax1 = plt.subplots(figsize=(10, 5))

# Bar plot
bar_width = 0.2
index = np.arange(len(sources))
bar1 = ax1.bar(
    index, cost_per_kwh, bar_width, label=labels[0], color="#3b76af"
)
bar2 = ax1.bar(
    index + bar_width,
    emissions_per_kwh,
    bar_width,
    label=labels[1],
    color="#ef8636",
)
bar3 = ax1.bar(
    index + 2 * bar_width, efficiency, bar_width, label=labels[2], color="#529e3f"
)
bar4 = ax1.bar(
    index + 3 * bar_width,
    setup_time_years,
    bar_width,
    label=labels[3],
    color="#c53a32",
)

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(
    index + bar_width + bar_width / 2,
    output_mwh,
    label="Output",
    color="black",
    marker="o",
    markersize=14,
    linewidth=2,
    markeredgecolor="white",
)

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=12)
ax1.set_ylabel(bar_name, fontsize=12)
ax1.set_xticks(index + bar_width + bar_width / 2)
ax1.set_xticklabels(sources, fontsize=12)
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")
ax2.set_ylabel(line_name, fontsize=12)

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('CB_4.pdf', bbox_inches='tight')
