import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data representing battery capacity (mAh) before and after a certain number of charge cycles
x = [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100]
y = [95, 190, 280, 370, 460, 550, 640, 730, 820, 910, 1000]
percentages = [
    "95%",
    "95%",
    "93%",
    "92.5%",
    "92%",
    "91.6%",
    "91.4%",
    "91.2%",
    "91.1%",
    "91%",
    "90.9%",
]

# Axes Limits and Labels
xlabel_value = "Battery Capacity (mAh) Before Charge Cycles"
ylabel_value = "Battery Capacity (mAh) After Charge Cycles"
xticklabels = [f"{num}mAh" for num in x]
yticklabels = [f"{num}mAh" for num in y]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot data with different marker style
ax.plot(x, y, color="black", linewidth=2)
ax.scatter(x, y, marker="o", color="#3b76af", s=100)

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Set ticks
ax.set_xticks(x)
ax.set_yticks(y)

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=9)
ax.set_yticklabels(yticklabels, fontsize=9)

# Set grid with lighter lines
ax.grid(True, linestyle="--", linewidth=0.5, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('CB_7.pdf', bbox_inches='tight')
