import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Initialize labels and a numpy array to make sure you have
# N labels of N number of values in the array
xlabels = ["Q1", "Q2", "Q3", "Q4", "Q5"]
sales_team_A = np.array([15000, 30000, 45000, 40000, 52000])
sales_team_B = np.array([40000, 55000, 70000, 68000, 75000])

# Labels and Plot Types
hat_graph_label = ["Sales Team A", "Sales Team B"]

# Axes Limits and Labels
xlabel_value = "Quarters"
ylabel_value = "Sales ($)"
ylim_values = [0, 100000]
title = "Quarterly Sales by Team"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
def hat_graph(ax, xlabels, values, group_labels):
    def label_bars(heights, rects):
        """Attach a text label on top of each bar."""
        for height, rect in zip(heights, rects):
            ax.annotate(
                f"{height}",
                xy=(rect.get_x() + rect.get_width() / 2, height),
                xytext=(0, 4),  # 4 points vertical offset.
                textcoords="offset points",
                ha="center",
                va="bottom",
            )

    values = np.asarray(values)
    x = np.arange(values.shape[1])
    ax.set_xticks(x, labels=xlabels)
    spacing = 0.3  # spacing between hat groups
    width = (1 - spacing) / values.shape[0]
    heights0 = values[0]
    for i, (heights, group_label) in enumerate(zip(values, group_labels)):
        style = (
            {"fill": False, "edgecolor": "black"}
            if i == 0
            else {"edgecolor": "black", "color": "#64a36c"}
        )
        rects = ax.bar(
            x - spacing / 2 + i * width,
            heights - heights0,
            width,
            bottom=heights0,
            label=group_label,
            **style,
        )
        label_bars(heights, rects)


fig, ax = plt.subplots(figsize=(7, 5))
hat_graph(ax, xlabels, [sales_team_A, sales_team_B], hat_graph_label)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_ylim(ylim_values)
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig('HR_19.pdf', bbox_inches='tight')
