# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample AI performance data (model accuracy and training time)
import numpy as np; np.random.seed(0)
model_accuracy_A = np.random.normal(85, 5, 10)  # Model accuracy for Algorithm A
model_accuracy_B = np.random.normal(70, 10, 10)  # Model accuracy for Algorithm B
training_time_A = np.random.normal(90, 8, 10)  # Training time for Algorithm A
training_time_B = np.random.normal(65, 12, 10)  # Training time for Algorithm B
accuracy_and_time_A = np.concatenate([model_accuracy_A, training_time_A])
accuracy_and_time_B = np.concatenate([model_accuracy_B, training_time_B])

model_precision_X = np.random.normal(88, 3, 5)  # Model precision for Algorithm X
model_precision_Y = np.random.normal(75, 4, 5)  # Model precision for Algorithm Y

processing_speed_X = np.random.normal(80, 5, 5)  # Processing speed for Algorithm X
processing_speed_Y = np.random.normal(70, 6, 5)  # Processing speed for Algorithm Y

xlabel = "Model Accuracy (%)"
ylabel = "Training Time (hours)"
ax1xlim = [60, 100]
ax1ylim = [50, 100]
diffline1 = [[0, 0], [60, 100], [50, 100]]
diffline2 = [[0, 0], [70, 90], [60, 80]]
annotaterecx1 = [70, 90]
annotaterecy1 = [60, 80]
ax2xlim = [70, 90]
ax2ylim = [60, 80]
plotup1 = [70, 80]
plotdown1 = [70, 60]
label = ["Algorithm A (Accuracy)", "Algorithm X (Precision)", "Algorithm Y (Processing Speed)"]
label2 = ["Overfitting Risk Zone", "Efficient Training Zone"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(accuracy_and_time_A, accuracy_and_time_B, marker="^", color="green", label=label[0])
ax1.scatter(model_precision_X, model_precision_Y, marker="o", color="blue", label=label[1])
ax1.scatter(processing_speed_X, processing_speed_Y, marker="s", color="brown", label=label[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="red", alpha=0.2, label=label2[0])
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="green", alpha=0.2, label=label2[1])

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle='--')
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle='--')

ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[1], annotaterecy1[1]], color="black", lw=1, linestyle='--')
ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[0]], color="black", lw=1, linestyle='--')
ax1.plot([annotaterecx1[0], annotaterecx1[0]], [annotaterecy1[0], annotaterecy1[1]], color="black", lw=1, linestyle='--')
ax1.plot([annotaterecx1[1], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[1]], color="black", lw=1, linestyle='--')

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")

# Scatter plots for the second axis
ax2.scatter(accuracy_and_time_A, accuracy_and_time_B, marker="^", color="green")
ax2.scatter(model_precision_X, model_precision_Y, marker="o", color="blue")
ax2.scatter(processing_speed_X, processing_speed_Y, marker="s", color="brown")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="red", alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="green", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle='--')
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle='--')
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('PIP_14.pdf', bbox_inches='tight')