# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(0)
# Generate some economic data
public_transport_usage = [
    500,
    800,
    1100,
    1500,
    1900,
    2200,
    2600,
    3000,
    3400,
    3700,
    3900,
]  # Public Transportation Data Usage (in GB)
ride_sharing_usage = [
    1500,
    1700,
    2000,
    2300,
    2600,
    3000,
    3400,
    3800,
    4100,
    4300,
    4500,
]  # Ride-sharing Data Usage (in GB)
time_bins = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
labels = ["Public Transport", "Ride-sharing"]
xmainlabel = "Adoption Time Frame (Years)"
xmainlim = [-0.1, 1.1]
xmainticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
ymainlabel = "Data Usage (in GB)"
ymainlim = [0, 10000]
ymainticks = [0, 2000, 4000, 6000, 8000, 10000]

xinsetlim = [-0.05, 0.35]
xinsetticks = [0.0,0.1, 0.2, 0.3]
yinsetlim = [0, 3000]
yinsetticks = [0, 1000, 2000, 3000]

# Coordinates for lines connecting the plots (main and inset)
main_plot_line_coords = [(-0.05, 2000), (0.4, 0)]
inset_plot_line_coords = [(0.0, 0), (0.3, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.05  # Slightly less than the bin width to create a gap
ax_main.bar(
    time_bins,
    public_transport_usage,
    width=bar_width,
    color="#4CAF50",  # Green for Public Sector
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    time_bins,
    ride_sharing_usage,
    width=bar_width,
    color="#2196F3",  # Blue for Private Sector
    align="center",
    bottom=public_transport_usage,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 16})
ax_main.grid()

# Inset plot configuration
ax_inset = fig.add_axes([0.15, 0.45, 0.3, 0.4])
ax_inset.bar(
    time_bins[:4],
    public_transport_usage[:4],
    width=bar_width,
    color="#4CAF50",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    time_bins[:4],
    ride_sharing_usage[:4],
    width=bar_width,
    color="#2196F3",
    align="center",
    bottom=public_transport_usage[:4],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)
ax_inset.grid()

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(main_plot_line_coords[0])
main_plot_right = ax_main.transData.transform_point(main_plot_line_coords[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(inset_plot_line_coords[0])
inset_right = ax_inset.transData.transform_point(inset_plot_line_coords[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('PIP_16.pdf', bbox_inches='tight')