# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated Population Data for plotting
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
ev_exp_growth = np.array([60000, 55000, 60500, 66550, 73205, 80525])  # Exponential growth for Electric Vehicles
ev_lin_growth = np.array([52000, 50000, 54000, 53000, 52000, 53000])  # Linear growth for Electric Vehicles
hv_exp_growth = np.array([200000, 110000, 121000, 133100, 146410, 161051])  # Exponential growth for Hybrid Vehicles
hv_lin_growth = np.array([200000, 103000, 106000, 109000, 112000, 115000])  # Linear growth for Hybrid Vehicles

labels = [
    "Electric Vehicles | Exponential Growth",
    "Electric Vehicles | Linear Growth",
    "Hybrid Vehicles | Exponential Growth",
    "Hybrid Vehicles | Linear Growth"
]
xlabel = "Year"
ylabel = "Number of Vehicles"
title = "Growth of Electric and Hybrid Vehicles Over Time"

# Labels and tick mark settings
xticks = years
yticks = np.linspace(0, 350000, 5)
yticklabels = [f"{int(x):,} Vehicles" for x in yticks]
inset_axes = [0.4, 0.50, 0.3, 0.25]
inset_ylim = [24000, 80000]
yticks_inset = np.linspace(25000, 80000, 3)
x_years = [f"{int(x)}" for x in years]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data with different styles and colors
ax.plot(years, ev_exp_growth, "o-", label=labels[0], color="brown")
ax.plot(years, ev_lin_growth, "x--", label=labels[1], color="brown")
ax.plot(years, hv_exp_growth, "o-", label=labels[2], color="purple")
ax.plot(years, hv_lin_growth, "x--", label=labels[3], color="purple")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits and ticks
ax.set_ylim([0, 350000])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend()

# Create an inset axis for Region A data
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, ev_exp_growth, "o-", color="brown")
ax_inset.plot(years, ev_lin_growth, "x--", color="brown")

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2010, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(x_years)

# --------------------
# Part 4: Saving Output
# --------------------
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('PIP_17.pdf', bbox_inches='tight')